<?php

use Elementor\Plugin;

function marvy_pro_get_config() {
    return $GLOBALS['marvy_pro_config']['bg-animation'];
}

function marvy_pro_get_setting($element = null) {
    $animations = marvy_pro_get_config();
    $defaults =  array_fill_keys(array_keys($animations), true);
    $elements = get_option('marvy_option_settings');
    $elements = array_merge($defaults, $elements);

    return (isset($element) ? (isset($elements[$element]) ? $elements[$element] : 0) : array_keys(array_filter($elements)));
}

function is_marvy_pro_preview_mode() {
    if (isset($_REQUEST['elementor-preview'])) {
        return false;
    }

    if (isset($_REQUEST['ver'])) {
        return false;
    }

    if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'elementor') {
        return false;
    }
    return true;
}

function marvy_pro_filter_widgets($id = null) {
    $animations = marvy_pro_get_config();
    $defaults =  array_keys($animations);

    $new_default = array_map(function ($animation) {
        return 'marvy_enable_' . $animation;
    }, $defaults);

    if (!Plugin::$instance->db->is_built_with_elementor($id)) return;

    $elements = Plugin::$instance->documents->get($id);
    $collections = [];

    foreach ($elements->get_elements_data() as $key => $element) {
        if(count($element['settings']) != 0){
            $collections = array_merge($collections,array_values(array_keys($element['settings'])));
        }
    }

    return array_map(function ($animation) {
        return substr($animation,13);
    }, array_intersect($new_default,$collections));

}

/**
 * Make lite version available for Pro
 *
 */
function marvy_make_lite_version() {
    // Get marvy animation lite version basename
    $basename = '';
    $plugins = get_plugins();
    foreach ($plugins as $key => $data) {
        if ($data['TextDomain'] === "marvy-animation-addons-for-elementor-lite") {
            $basename = $key;
        }
    }

    $plugin_data = get_marvy_plugin_data('marvy-animation-addons-for-elementor-lite');

    if (is_marvy_plugin_installed($basename)) {
        // upgrade plugin
        if (isset($plugin_data->version) && marvy_pro_get_lite_plugin_version($basename) != $plugin_data->version) {
            marvy_pro_upgrade_plugin($basename);
        }

        if (!is_plugin_active($basename)) {
            activate_plugin(marvy_call_path(WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $basename), '', false, false);
            return true;
        }
    } else {
        if (isset($plugin_data->download_link)) {
            marvy_install_plugin($plugin_data->download_link);
            return true;
        }
    }
    return false;
}

function marvy_pro_get_lite_plugin_version($basename) {
    if (!function_exists('get_plugins')) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    $plugins = get_plugins();
    return $plugins[$basename]['Version'];
}

function marvy_pro_upgrade_plugin($basename) {
    include_once ABSPATH . 'wp-admin/includes/file.php';
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    include_once ABSPATH . 'wp-admin/includes/class-automatic-upgrader-skin.php';

    $skin = new \Automatic_Upgrader_Skin;
    $upgrader = new \Plugin_Upgrader($skin);
    $upgrader->upgrade($basename);

    return $skin->result;
}

function is_marvy_plugin_installed($basename) {
    if (!function_exists('get_plugins')) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    $plugins = get_plugins();

    return isset($plugins[$basename]);
}

function marvy_call_path($path) {
    $path = str_replace(['//', '\\\\'], ['/', '\\'], $path);

    return str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
}

function marvy_install_plugin($plugin_url) {
    include_once ABSPATH . 'wp-admin/includes/file.php';
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    include_once ABSPATH . 'wp-admin/includes/class-automatic-upgrader-skin.php';

    $skin = new \Automatic_Upgrader_Skin;
    $upgrade = new \Plugin_Upgrader($skin);
    $upgrade->install($plugin_url);

    // activate plugin
    activate_plugin($upgrade->plugin_info(), '', false, false);

    return $skin->result;
}

function get_marvy_plugin_data($slug = '') {
    $args = array(
        'slug' => $slug,
        'fields' => array(
            'version' => false,
        ),
    );

    $response = wp_remote_post(
        'http://api.wordpress.org/plugins/info/1.0/',
        array(
            'body' => array(
                'action' => 'plugin_information',
                'request' => serialize((object) $args),
            ),
        )
    );

    if (is_wp_error($response)) {
        return false;
    } else {
        $response = unserialize(wp_remote_retrieve_body($response));

        if ($response) {
            return $response;
        } else {
            return false;
        }
    }
}

function marvy_if_failed_load() {
    if (!current_user_can('activate_plugins')) {
        return;
    }

    // Get marvy animation lite version basename
    $basename = '';
    $plugins = get_plugins();
    foreach ($plugins as $key => $data) {
        if ($data['TextDomain'] === "marvy-animation-addons-for-elementor-lite") {
            $basename = $key;
        }
    }

    $folder_name = explode("/",$basename);

    if (is_marvy_plugin_installed($basename) && is_plugin_active($basename)) {
        return;
    }

    if (is_marvy_plugin_installed($basename)) {
        $url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $basename . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $basename);
        $message = __('<strong>Marvy Animation Addons - Pro</strong> requires <strong>Marvy - Ultimate Elementor Animation addons</strong> plugin to be active. Please activate Marvy Animation Addons - Lite for Marvy Animation Pro to continue.', 'marvy-animation-addons');
        $button_text = __('Activate Marvy Addons for Elementor', 'marvy-animation-addons');
    } else {
        $url = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=marvy-animation-addons-for-elementor-lite'), 'install-plugin_marvy-animation-addons-for-elementor-lite');
        $message = sprintf(__('<strong>Marvy Animation Addons - Pro</strong> requires <strong>Marvy - Ultimate Elementor Animation addons</strong> plugin to be installed and activated. Please install Marvi Animation Addons - Lite for Marvy Animation Pro to continue.', 'marvy-animation-addons'), '<strong>', '</strong>');
        $button_text = __('Install Marvy Addons for Elementor', 'marvy-animation-addons');
    }

    $button = '<p><a href="' . $url . '" class="button-primary">' . $button_text . '</a></p>';

    printf('<div class="error"><p>%1$s</p>%2$s</div>', __($message), $button);
}

function marvy_if_license_deactivate() {
    if (!current_user_can('activate_plugins')) {
        return;
    }

    $url = wp_nonce_url(self_admin_url('admin.php?page=marvy-animation'));
    $message = sprintf(__('<strong>Marvy Animation Addons - Pro</strong> requires <strong>License Code</strong> for use pro features. Please enter license code for Marvy Animation Pro to continue.', 'marvy-animation-addons'), '<strong>', '</strong>');
    $button_text = __('Add License Code for Marvy Animation Addons Pro', 'marvy-animation-addons');

    $button = '<p><a href="' . $url . '" class="button-primary">' . $button_text . '</a></p>';

    printf('<div class="notice notice-warning"><p>%1$s</p>%2$s</div>', __($message), $button);
}